@extends('layouts.app')
@section('title','Data Karyawan (Talenta)')
@section('page-title','Data Karyawan (Talenta)')

@section('content')
<div class="bg-white p-4 rounded-xl shadow">
  @if ($errors->any())
    <div class="mb-3 bg-red-50 text-red-700 p-3 rounded">@foreach ($errors->all() as $e)<div>{{ $e }}</div>@endforeach</div>
  @endif
  @if(!empty($notice))
    <div class="mb-3 bg-amber-50 text-amber-800 p-3 rounded">{{ $notice }}</div>
  @endif

  <form method="GET" class="mb-4 grid grid-cols-1 md:grid-cols-7 gap-3 items-end">
    <div>
      <label class="block text-xs text-gray-500 mb-1">Limit</label>
      <input type="number" name="limit" value="{{ $limit }}" class="border rounded px-3 py-2 w-full">
    </div>
    <div>
      <label class="block text-xs text-gray-500 mb-1">Page</label>
      <input type="number" name="page" value="{{ $page }}" class="border rounded px-3 py-2 w-full">
    </div>
    <div>
      <label class="block text-xs text-gray-500 mb-1">User ID (langsung detail)</label>
      <input type="text" name="user_id" value="{{ request('user_id','') }}" placeholder="3878753" class="border rounded px-3 py-2 w-full">
    </div>
    <div>
      <label class="block text-xs text-gray-500 mb-1">First name</label>
      <input type="text" name="first_name" value="{{ request('first_name','') }}" placeholder="Hambali Fitrianto" class="border rounded px-3 py-2 w-full">
    </div>
    <div>
      <label class="block text-xs text-gray-500 mb-1">Employee ID</label>
      <input type="text" name="employee_id" value="{{ request('employee_id','') }}" placeholder="KM10008048" class="border rounded px-3 py-2 w-full">
    </div>
    <div>
      <label class="block text-xs text-gray-500 mb-1">Status</label>
      <select name="status" class="border rounded px-3 py-2 w-full">
        @php $curStatus = $status ?? request('status',''); @endphp
        <option value="" {{ $curStatus==='' ? 'selected' : '' }}>All</option>
        <option value="Active" {{ $curStatus==='Active' ? 'selected' : '' }}>Active</option>
        <option value="Inactive" {{ $curStatus==='Inactive' ? 'selected' : '' }}>Inactive</option>
      </select>
    </div>
    <div class="md:col-span-1 flex gap-2">
      <button class="w-full px-4 py-2 rounded bg-slate-700 text-white">Cari / Reload</button>
      <a href="{{ route('talenta.employees.index') }}" class="px-4 py-2 rounded border">Reset</a>
    </div>
  </form>

  @php
    $gv = function(array $row, array $alts, $default='') {
      foreach ($alts as $k) { $v = data_get($row, $k); if (!is_null($v) && $v!=='') return $v; }
      return $default;
    };
    $rows = $items ?? [];
  @endphp

  <div class="overflow-x-auto">
    <table class="min-w-[900px] w-full text-sm border">
      <thead class="bg-slate-50">
        <tr class="text-left border-b">
          <th class="py-2 px-3">#</th>
          <th class="py-2 px-3">Employee name</th>
          <th class="py-2 px-3">Employee Id</th>
          <th class="py-2 px-3">Email</th>
          <th class="py-2 px-3">Status</th>
          <th class="py-2 px-3">Action</th>
        </tr>
      </thead>
      <tbody>
        @forelse($rows as $i => $it)
          @php
            $uid   = $it['user_id'] ?? '';
            $fn    = $gv($it, ['personal.first_name']);
            $ln    = $gv($it, ['personal.last_name']);
            $name  = trim(($fn ?: '').' '.($ln ?: ''));
            $email = $gv($it, ['personal.email']);
            $empId = $gv($it, ['employment.employee_id','employee_id','user_id']);
            $stat  = $gv($it, ['employment.status','status']);
          @endphp
          <tr class="border-b hover:bg-slate-50">
            <td class="py-2 px-3">{{ $i+1 }}</td>
            <td class="py-2 px-3 font-medium">{{ $name ?: '-' }}</td>
            <td class="py-2 px-3">{{ $empId }}</td>
            <td class="py-2 px-3">{{ $email }}</td>
            <td class="py-2 px-3">{{ $stat }}</td>
            <td class="py-2 px-3">
              @if($uid)
                <a class="inline-flex items-center gap-1 px-2 py-1 rounded border hover:bg-slate-50"
                   href="{{ route('talenta.employees.show', $uid) }}" title="Lihat detail">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="w-4 h-4">
                    <path d="M12 5c-7 0-10 7-10 7s3 7 10 7 10-7 10-7-3-7-10-7zm0 12a5 5 0 1 1 0-10 5 5 0 0 1 0 10z"/>
                    <circle cx="12" cy="12" r="2.5"/>
                  </svg>
                  <span>View</span>
                </a>
              @endif
            </td>
          </tr>
        @empty
          <tr><td colspan="6" class="py-6 text-center text-gray-500">Tidak ada data.</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  @php
    $pg   = $pagination ?? [];
    $cur  = (int)($pg['current_page'] ?? $page ?? 1);
    $last = (int)($pg['last_page'] ?? 1);
    $start = max(1, $cur - 2);
    $end   = min($last, $cur + 2);
    $qs    = request()->except('page');
  @endphp

  @if($last > 1)
    <div class="mt-4 flex flex-wrap items-center gap-2">
      <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>1,'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $cur==1 ? 'pointer-events-none opacity-50' : 'hover:bg-slate-50' }}">« First</a>
      <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>max(1,$cur-1),'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $cur==1 ? 'pointer-events-none opacity-50' : 'hover:bg-slate-50' }}">‹ Prev</a>
      @for($i=$start; $i<=$end; $i++)
        <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>$i,'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $i==$cur ? 'bg-slate-800 text-white border-slate-800' : 'hover:bg-slate-50' }}">{{ $i }}</a>
      @endfor
      <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>min($last,$cur+1),'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $cur==$last ? 'pointer-events-none opacity-50' : 'hover:bg-slate-50' }}">Next ›</a>
      <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>$last,'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $cur==$last ? 'pointer-events-none opacity-50' : 'hover:bg-slate-50' }}">Last »</a>
      <div class="text-sm text-gray-600 ml-2">Page {{ $cur }} of {{ $last }} | Total: {{ $pg['total'] ?? '—' }}</div>
    </div>
  @endif

  <details class="mt-6">
    <summary class="cursor-pointer text-slate-600">Lihat RAW JSON</summary>
    <pre class="text-xs bg-slate-50 p-3 rounded overflow-auto">{{ json_encode($raw ?? [], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>
  </details>
</div>
@endsection
